document.addEventListener('DOMContentLoaded', function() {
    // Activate Bootstrap tooltips
    var tooltipTriggerList = [].slice.call(document.querySelectorAll('[data-bs-toggle="tooltip"]'));
    var tooltipList = tooltipTriggerList.map(function (tooltipTriggerEl) {
        return new bootstrap.Tooltip(tooltipTriggerEl);
    });
    
    // TOC active link highlighting
    const sections = document.querySelectorAll('.content-card');
    const tocLinks = document.querySelectorAll('.toc-link');
    
    function changeTOCActiveLink() {
        let currentSectionId = '';
        
        sections.forEach(section => {
            const sectionTop = section.offsetTop;
            const sectionHeight = section.clientHeight;
            if (window.scrollY >= (sectionTop - 100)) {
                currentSectionId = section.getAttribute('id');
            }
        });
        
        tocLinks.forEach(link => {
            link.classList.remove('active');
            if (link.getAttribute('href') === `#${currentSectionId}`) {
                link.classList.add('active');
            }
        });
    }
    
    window.addEventListener('scroll', changeTOCActiveLink);
    
    // Initialize feedback buttons
    const feedbackBtns = document.querySelectorAll('.feedback-btn');
    const feedbackForm = document.getElementById('feedbackForm');
    
    feedbackBtns.forEach(btn => {
        btn.addEventListener('click', function() {
            feedbackForm.classList.add('show');
        });
    });
});